/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.sparta;

import com.hp.hpl.sparta.CharCircBuffer;
import com.hp.hpl.sparta.Element;
import com.hp.hpl.sparta.EncodingMismatchException;
import com.hp.hpl.sparta.ParseException;
import com.hp.hpl.sparta.ParseHandler;
import com.hp.hpl.sparta.ParseLog;
import com.hp.hpl.sparta.ParseSource;
import com.hp.hpl.sparta.Sparta;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;

class ParseCharStream
implements ParseSource {
    private static final boolean DEBUG = true;
    private static final boolean H_DEBUG = false;
    private static final char[] NAME_PUNCT_CHARS = new char[]{'.', '-', '_', ':'};
    private static final int MAX_COMMON_CHAR = 128;
    private static final boolean[] IS_NAME_CHAR = new boolean[128];
    private static final char[] COMMENT_BEGIN;
    private static final char[] COMMENT_END;
    private static final char[] PI_BEGIN;
    private static final char[] QU_END;
    private static final char[] DOCTYPE_BEGIN;
    private static final char[] XML_BEGIN;
    private static final char[] ENCODING;
    private static final char[] VERSION;
    private static final char[] VERSIONNUM_PUNC_CHARS;
    private static final char[] MARKUPDECL_BEGIN;
    private static final char[] CHARREF_BEGIN;
    private static final char[] ENTITY_BEGIN;
    private static final char[] NDATA;
    private static final char[] SYSTEM;
    private static final char[] PUBLIC;
    private static final char[] BEGIN_CDATA;
    private static final char[] END_CDATA;
    private static final char[] END_EMPTYTAG;
    private static final char[] BEGIN_ETAG;
    private String systemId_;
    private String docTypeName_ = null;
    private final Reader reader_;
    private final Hashtable entities_ = new Hashtable();
    private final Hashtable pes_ = new Hashtable();
    private final ParseLog log_;
    private final String encoding_;
    private int ch_ = -2;
    private boolean isExternalDtd_ = false;
    private final int CBUF_SIZE = 1024;
    private final char[] cbuf_;
    private int curPos_ = 0;
    private int endPos_ = 0;
    private boolean eos_ = false;
    private static final int TMP_BUF_SIZE = 255;
    private final char[] tmpBuf_ = new char[255];
    private int lineNumber_ = 1;
    private final CharCircBuffer history_ = null;
    public static final int HISTORY_LENGTH = 100;
    private final ParseHandler handler_;

    public ParseCharStream(String string, char[] cArray, ParseLog parseLog, String string2, ParseHandler parseHandler) throws ParseException, EncodingMismatchException, IOException {
        this(string, null, cArray, parseLog, string2, parseHandler);
    }

    public ParseCharStream(String string, Reader reader, ParseLog parseLog, String string2, ParseHandler parseHandler) throws ParseException, EncodingMismatchException, IOException {
        this(string, reader, null, parseLog, string2, parseHandler);
    }

    public ParseCharStream(String string, Reader reader, char[] cArray, ParseLog parseLog, String string2, ParseHandler parseHandler) throws ParseException, EncodingMismatchException, IOException {
        this.log_ = parseLog == null ? ParseSource.DEFAULT_LOG : parseLog;
        this.encoding_ = string2 == null ? null : string2.toLowerCase();
        this.entities_.put("lt", "<");
        this.entities_.put("gt", ">");
        this.entities_.put("amp", "&");
        this.entities_.put("apos", "'");
        this.entities_.put("quot", "\"");
        if (cArray != null) {
            this.cbuf_ = cArray;
            this.curPos_ = 0;
            this.endPos_ = this.cbuf_.length;
            this.eos_ = true;
            this.reader_ = null;
        } else {
            this.reader_ = reader;
            this.cbuf_ = new char[1024];
            this.fillBuf();
        }
        this.systemId_ = string;
        this.handler_ = parseHandler;
        this.handler_.setParseSource(this);
        this.readProlog();
        this.handler_.startDocument();
        Element element = this.readElement();
        if (this.docTypeName_ != null && !this.docTypeName_.equals(element.getTagName())) {
            this.log_.warning("DOCTYPE name \"" + this.docTypeName_ + "\" not same as tag name, \"" + element.getTagName() + "\" of root element", this.systemId_, this.getLineNumber());
        }
        while (this.isMisc()) {
            this.readMisc();
        }
        if (this.reader_ != null) {
            this.reader_.close();
        }
        this.handler_.endDocument();
    }

    public String toString() {
        return this.systemId_;
    }

    public String getSystemId() {
        return this.systemId_;
    }

    public int getLineNumber() {
        return this.lineNumber_;
    }

    int getLastCharRead() {
        return this.ch_;
    }

    final String getHistory() {
        return "";
    }

    private int fillBuf() throws IOException {
        int n;
        if (this.eos_) {
            return -1;
        }
        if (this.endPos_ == this.cbuf_.length) {
            this.endPos_ = 0;
            this.curPos_ = 0;
        }
        if ((n = this.reader_.read(this.cbuf_, this.endPos_, this.cbuf_.length - this.endPos_)) <= 0) {
            this.eos_ = true;
            return -1;
        }
        this.endPos_ += n;
        return n;
    }

    private int fillBuf(int n) throws IOException {
        int n2;
        if (this.eos_) {
            return -1;
        }
        int n3 = 0;
        if (this.cbuf_.length - this.curPos_ < n) {
            n2 = 0;
            while (this.curPos_ + n2 < this.endPos_) {
                this.cbuf_[n2] = this.cbuf_[this.curPos_ + n2];
                ++n2;
            }
            this.endPos_ = n3 = this.endPos_ - this.curPos_;
            this.curPos_ = 0;
        }
        if ((n2 = this.fillBuf()) == -1) {
            if (n3 == 0) {
                return -1;
            }
            return n3;
        }
        return n3 + n2;
    }

    private final char readChar() throws ParseException, IOException {
        if (this.curPos_ >= this.endPos_ && this.fillBuf() == -1) {
            throw new ParseException(this, "unexpected end of expression.");
        }
        if (this.cbuf_[this.curPos_] == '\n') {
            ++this.lineNumber_;
        }
        return this.cbuf_[this.curPos_++];
    }

    private final char peekChar() throws ParseException, IOException {
        if (this.curPos_ >= this.endPos_ && this.fillBuf() == -1) {
            throw new ParseException(this, "unexpected end of expression.");
        }
        return this.cbuf_[this.curPos_];
    }

    private final void readChar(char c) throws ParseException, IOException {
        char c2 = this.readChar();
        if (c2 != c) {
            throw new ParseException(this, c2, c);
        }
    }

    private final boolean isChar(char c) throws ParseException, IOException {
        if (this.curPos_ >= this.endPos_ && this.fillBuf() == -1) {
            throw new ParseException(this, "unexpected end of expression.");
        }
        return this.cbuf_[this.curPos_] == c;
    }

    private final char readChar(char c, char c2) throws ParseException, IOException {
        char c3 = this.readChar();
        if (c3 != c && c3 != c2) {
            throw new ParseException(this, c3, new char[]{c, c2});
        }
        return c3;
    }

    private final char readChar(char c, char c2, char c3, char c4) throws ParseException, IOException {
        char c5 = this.readChar();
        if (c5 != c && c5 != c2 && c5 != c3 && c5 != c4) {
            throw new ParseException(this, c5, new char[]{c, c2, c3, c4});
        }
        return c5;
    }

    private final boolean isChar(char c, char c2) throws ParseException, IOException {
        if (this.curPos_ >= this.endPos_ && this.fillBuf() == -1) {
            return false;
        }
        char c3 = this.cbuf_[this.curPos_];
        return c3 == c || c3 == c2;
    }

    private final boolean isChar(char c, char c2, char c3, char c4) throws ParseException, IOException {
        if (this.curPos_ >= this.endPos_ && this.fillBuf() == -1) {
            return false;
        }
        char c5 = this.cbuf_[this.curPos_];
        return c5 == c || c5 == c2 || c5 == c3 || c5 == c4;
    }

    private static final boolean isIn(char c, char[] cArray) {
        int n = 0;
        while (n < cArray.length) {
            if (c == cArray[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private final void readS() throws ParseException, IOException {
        this.readChar(' ', '\t', '\r', '\n');
        while (this.isChar(' ', '\t', '\r', '\n')) {
            this.readChar();
        }
    }

    private final boolean isS() throws ParseException, IOException {
        return this.isChar(' ', '\t', '\r', '\n');
    }

    private boolean isNameChar() throws ParseException, IOException {
        char c = this.peekChar();
        return c < '\u0080' ? IS_NAME_CHAR[c] : ParseCharStream.isNameChar(c);
    }

    private static boolean isLetter(char c) {
        return "abcdefghijklmnopqrstuvwxyz".indexOf(Character.toLowerCase(c)) != -1;
    }

    private static boolean isNameChar(char c) {
        return Character.isDigit(c) || ParseCharStream.isLetter(c) || ParseCharStream.isIn(c, NAME_PUNCT_CHARS) || ParseCharStream.isExtender(c);
    }

    private static boolean isExtender(char c) {
        switch (c) {
            case '\u00b7': 
            case '\u02d0': 
            case '\u02d1': 
            case '\u0387': 
            case '\u0640': 
            case '\u0e46': 
            case '\u0ec6': 
            case '\u3005': 
            case '\u3031': 
            case '\u3032': 
            case '\u3033': 
            case '\u3034': 
            case '\u3035': 
            case '\u309d': 
            case '\u309e': 
            case '\u30fc': 
            case '\u30fd': 
            case '\u30fe': {
                return true;
            }
        }
        return false;
    }

    private final String readName() throws ParseException, IOException {
        StringBuffer stringBuffer = null;
        int n = 0;
        this.tmpBuf_[n++] = this.readNameStartChar();
        while (this.isNameChar()) {
            if (n >= 255) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(n);
                    stringBuffer.append(this.tmpBuf_, 0, n);
                } else {
                    stringBuffer.append(this.tmpBuf_, 0, n);
                }
                n = 0;
            }
            this.tmpBuf_[n++] = this.readChar();
        }
        if (stringBuffer == null) {
            return Sparta.intern(new String(this.tmpBuf_, 0, n));
        }
        stringBuffer.append(this.tmpBuf_, 0, n);
        return stringBuffer.toString();
    }

    private char readNameStartChar() throws ParseException, IOException {
        char c = this.readChar();
        if (!ParseCharStream.isLetter(c) && c != '_' && c != ':') {
            throw new ParseException(this, c, "letter, underscore, colon");
        }
        return c;
    }

    private final String readEntityValue() throws ParseException, IOException {
        char c = this.readChar('\'', '\"');
        StringBuffer stringBuffer = new StringBuffer();
        while (!this.isChar(c)) {
            if (this.isPeReference()) {
                stringBuffer.append(this.readPeReference());
                continue;
            }
            if (this.isReference()) {
                stringBuffer.append(this.readReference());
                continue;
            }
            stringBuffer.append(this.readChar());
        }
        this.readChar(c);
        return stringBuffer.toString();
    }

    private final boolean isEntityValue() throws ParseException, IOException {
        return this.isChar('\'', '\"');
    }

    private final void readSystemLiteral() throws ParseException, IOException {
        char c = this.readChar();
        while (this.peekChar() != c) {
            this.readChar();
        }
        this.readChar(c);
    }

    private final void readPubidLiteral() throws ParseException, IOException {
        this.readSystemLiteral();
    }

    private boolean isMisc() throws ParseException, IOException {
        return this.isComment() || this.isPi() || this.isS();
    }

    private void readMisc() throws ParseException, IOException {
        if (this.isComment()) {
            this.readComment();
        } else if (this.isPi()) {
            this.readPi();
        } else if (this.isS()) {
            this.readS();
        } else {
            throw new ParseException(this, "expecting comment or processing instruction or space");
        }
    }

    private final void readComment() throws ParseException, IOException {
        this.readSymbol(COMMENT_BEGIN);
        while (!this.isSymbol(COMMENT_END)) {
            this.readChar();
        }
        this.readSymbol(COMMENT_END);
    }

    private final boolean isComment() throws ParseException, IOException {
        return this.isSymbol(COMMENT_BEGIN);
    }

    private final void readPi() throws ParseException, IOException {
        this.readSymbol(PI_BEGIN);
        while (!this.isSymbol(QU_END)) {
            this.readChar();
        }
        this.readSymbol(QU_END);
    }

    private final boolean isPi() throws ParseException, IOException {
        return this.isSymbol(PI_BEGIN);
    }

    private void readProlog() throws ParseException, EncodingMismatchException, IOException {
        if (this.isXmlDecl()) {
            this.readXmlDecl();
        }
        while (this.isMisc()) {
            this.readMisc();
        }
        if (this.isDocTypeDecl()) {
            this.readDocTypeDecl();
            while (this.isMisc()) {
                this.readMisc();
            }
        }
    }

    private boolean isDocTypeDecl() throws ParseException, IOException {
        return this.isSymbol(DOCTYPE_BEGIN);
    }

    /*
     * Unable to fully structure code
     */
    private void readXmlDecl() throws ParseException, EncodingMismatchException, IOException {
        this.readSymbol(ParseCharStream.XML_BEGIN);
        this.readVersionInfo();
        if (this.isS()) {
            this.readS();
        }
        if (!this.isEncodingDecl()) ** GOTO lbl11
        var1_1 = this.readEncodingDecl();
        if (this.encoding_ == null || var1_1.toLowerCase().equals(this.encoding_)) ** GOTO lbl11
        throw new EncodingMismatchException(this.systemId_, var1_1, this.encoding_);
lbl-1000:
        // 1 sources

        {
            this.readChar();
lbl11:
            // 3 sources

            ** while (!this.isSymbol((char[])ParseCharStream.QU_END))
        }
lbl12:
        // 1 sources

        this.readSymbol(ParseCharStream.QU_END);
    }

    private boolean isXmlDecl() throws ParseException, IOException {
        return this.isSymbol(XML_BEGIN);
    }

    private boolean isEncodingDecl() throws ParseException, IOException {
        return this.isSymbol(ENCODING);
    }

    private String readEncodingDecl() throws ParseException, IOException {
        this.readSymbol(ENCODING);
        this.readEq();
        char c = this.readChar('\'', '\"');
        StringBuffer stringBuffer = new StringBuffer();
        while (!this.isChar(c)) {
            stringBuffer.append(this.readChar());
        }
        this.readChar(c);
        return stringBuffer.toString();
    }

    private void readVersionInfo() throws ParseException, IOException {
        this.readS();
        this.readSymbol(VERSION);
        this.readEq();
        char c = this.readChar('\'', '\"');
        this.readVersionNum();
        this.readChar(c);
    }

    private final void readEq() throws ParseException, IOException {
        if (this.isS()) {
            this.readS();
        }
        this.readChar('=');
        if (this.isS()) {
            this.readS();
        }
    }

    private boolean isVersionNumChar() throws ParseException, IOException {
        char c = this.peekChar();
        return Character.isDigit(c) || 'a' <= c && c <= 'z' || 'Z' <= c && c <= 'Z' || ParseCharStream.isIn(c, VERSIONNUM_PUNC_CHARS);
    }

    private void readVersionNum() throws ParseException, IOException {
        this.readChar();
        while (this.isVersionNumChar()) {
            this.readChar();
        }
    }

    private void readDocTypeDecl() throws ParseException, IOException {
        this.readSymbol(DOCTYPE_BEGIN);
        this.readS();
        this.docTypeName_ = this.readName();
        if (this.isS()) {
            this.readS();
            if (!this.isChar('>') && !this.isChar('[')) {
                this.isExternalDtd_ = true;
                this.readExternalId();
                if (this.isS()) {
                    this.readS();
                }
            }
        }
        if (this.isChar('[')) {
            this.readChar();
            while (!this.isChar(']')) {
                if (this.isDeclSep()) {
                    this.readDeclSep();
                    continue;
                }
                this.readMarkupDecl();
            }
            this.readChar(']');
            if (this.isS()) {
                this.readS();
            }
        }
        this.readChar('>');
    }

    private void readDeclSep() throws ParseException, IOException {
        if (this.isPeReference()) {
            this.readPeReference();
        } else {
            this.readS();
        }
    }

    private boolean isDeclSep() throws ParseException, IOException {
        return this.isPeReference() || this.isS();
    }

    private void readMarkupDecl() throws ParseException, IOException {
        if (this.isPi()) {
            this.readPi();
        } else if (this.isComment()) {
            this.readComment();
        } else if (this.isEntityDecl()) {
            this.readEntityDecl();
        } else if (this.isSymbol(MARKUPDECL_BEGIN)) {
            while (!this.isChar('>')) {
                if (this.isChar('\'', '\"')) {
                    char c = this.readChar();
                    while (!this.isChar(c)) {
                        this.readChar();
                    }
                    this.readChar(c);
                    continue;
                }
                this.readChar();
            }
            this.readChar('>');
        } else {
            throw new ParseException(this, "expecting processing instruction, comment, or \"<!\"");
        }
    }

    private char readCharRef() throws ParseException, IOException {
        this.readSymbol(CHARREF_BEGIN);
        int n = 10;
        if (this.isChar('x')) {
            this.readChar();
            n = 16;
        }
        int n2 = 0;
        while (!this.isChar(';')) {
            this.tmpBuf_[n2++] = this.readChar();
            if (n2 < 255) continue;
            this.log_.warning("Tmp buffer overflow on readCharRef", this.systemId_, this.getLineNumber());
            return ' ';
        }
        this.readChar(';');
        String string = new String(this.tmpBuf_, 0, n2);
        try {
            return (char)Integer.parseInt(string, n);
        }
        catch (NumberFormatException numberFormatException) {
            this.log_.warning("\"" + string + "\" is not a valid " + (n == 16 ? "hexadecimal" : "decimal") + " number", this.systemId_, this.getLineNumber());
            return ' ';
        }
    }

    private final char[] readReference() throws ParseException, IOException {
        if (this.isSymbol(CHARREF_BEGIN)) {
            return new char[]{this.readCharRef()};
        }
        return this.readEntityRef().toCharArray();
    }

    private final boolean isReference() throws ParseException, IOException {
        return this.isChar('&');
    }

    private String readEntityRef() throws ParseException, IOException {
        this.readChar('&');
        String string = this.readName();
        String string2 = (String)this.entities_.get(string);
        if (string2 == null) {
            string2 = "";
            if (this.isExternalDtd_) {
                this.log_.warning("&" + string + "; not found -- possibly defined in external DTD)", this.systemId_, this.getLineNumber());
            } else {
                this.log_.warning("No declaration of &" + string + ";", this.systemId_, this.getLineNumber());
            }
        }
        this.readChar(';');
        return string2;
    }

    private String readPeReference() throws ParseException, IOException {
        this.readChar('%');
        String string = this.readName();
        String string2 = (String)this.pes_.get(string);
        if (string2 == null) {
            string2 = "";
            this.log_.warning("No declaration of %" + string + ";", this.systemId_, this.getLineNumber());
        }
        this.readChar(';');
        return string2;
    }

    private boolean isPeReference() throws ParseException, IOException {
        return this.isChar('%');
    }

    private void readEntityDecl() throws ParseException, IOException {
        this.readSymbol(ENTITY_BEGIN);
        this.readS();
        if (this.isChar('%')) {
            this.readChar('%');
            this.readS();
            String string = this.readName();
            this.readS();
            String string2 = this.isEntityValue() ? this.readEntityValue() : this.readExternalId();
            this.pes_.put(string, string2);
        } else {
            String string;
            String string3 = this.readName();
            this.readS();
            if (this.isEntityValue()) {
                string = this.readEntityValue();
            } else if (this.isExternalId()) {
                string = this.readExternalId();
                if (this.isS()) {
                    this.readS();
                }
                if (this.isSymbol(NDATA)) {
                    this.readSymbol(NDATA);
                    this.readS();
                    this.readName();
                }
            } else {
                throw new ParseException(this, "expecting double-quote, \"PUBLIC\" or \"SYSTEM\" while reading entity declaration");
            }
            this.entities_.put(string3, string);
        }
        if (this.isS()) {
            this.readS();
        }
        this.readChar('>');
    }

    private boolean isEntityDecl() throws ParseException, IOException {
        return this.isSymbol(ENTITY_BEGIN);
    }

    private String readExternalId() throws ParseException, IOException {
        if (this.isSymbol(SYSTEM)) {
            this.readSymbol(SYSTEM);
        } else if (this.isSymbol(PUBLIC)) {
            this.readSymbol(PUBLIC);
            this.readS();
            this.readPubidLiteral();
        } else {
            throw new ParseException(this, "expecting \"SYSTEM\" or \"PUBLIC\" while reading external ID");
        }
        this.readS();
        this.readSystemLiteral();
        return "(WARNING: external ID not read)";
    }

    private boolean isExternalId() throws ParseException, IOException {
        return this.isSymbol(SYSTEM) || this.isSymbol(PUBLIC);
    }

    private final void readSymbol(char[] cArray) throws ParseException, IOException {
        int n = cArray.length;
        if (this.endPos_ - this.curPos_ < n && this.fillBuf(n) <= 0) {
            this.ch_ = -1;
            throw new ParseException(this, "end of XML file", cArray);
        }
        this.ch_ = this.cbuf_[this.endPos_ - 1];
        if (this.endPos_ - this.curPos_ < n) {
            throw new ParseException(this, "end of XML file", cArray);
        }
        int n2 = 0;
        while (n2 < n) {
            if (this.cbuf_[this.curPos_ + n2] != cArray[n2]) {
                throw new ParseException(this, new String(this.cbuf_, this.curPos_, n), cArray);
            }
            ++n2;
        }
        this.curPos_ += n;
    }

    private final boolean isSymbol(char[] cArray) throws ParseException, IOException {
        int n = cArray.length;
        if (this.endPos_ - this.curPos_ < n && this.fillBuf(n) <= 0) {
            this.ch_ = -1;
            return false;
        }
        this.ch_ = this.cbuf_[this.endPos_ - 1];
        if (this.endPos_ - this.curPos_ < n) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (this.cbuf_[this.curPos_ + n2] != cArray[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private String readAttValue() throws ParseException, IOException {
        char c = this.readChar('\'', '\"');
        StringBuffer stringBuffer = new StringBuffer();
        while (!this.isChar(c)) {
            if (this.isReference()) {
                stringBuffer.append(this.readReference());
                continue;
            }
            stringBuffer.append(this.readChar());
        }
        this.readChar(c);
        return stringBuffer.toString();
    }

    private void readPossibleCharData() throws ParseException, IOException {
        int n = 0;
        while (!(this.isChar('<') || this.isChar('&') || this.isSymbol(END_CDATA))) {
            this.tmpBuf_[n] = this.readChar();
            if (this.tmpBuf_[n] == '\r' && this.peekChar() == '\n') {
                this.tmpBuf_[n] = this.readChar();
            }
            if (++n != 255) continue;
            this.handler_.characters(this.tmpBuf_, 0, 255);
            n = 0;
        }
        if (n > 0) {
            this.handler_.characters(this.tmpBuf_, 0, n);
        }
    }

    private void readCdSect() throws ParseException, IOException {
        StringBuffer stringBuffer = null;
        this.readSymbol(BEGIN_CDATA);
        int n = 0;
        while (!this.isSymbol(END_CDATA)) {
            if (n >= 255) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(n);
                    stringBuffer.append(this.tmpBuf_, 0, n);
                } else {
                    stringBuffer.append(this.tmpBuf_, 0, n);
                }
                n = 0;
            }
            this.tmpBuf_[n++] = this.readChar();
        }
        this.readSymbol(END_CDATA);
        if (stringBuffer != null) {
            stringBuffer.append(this.tmpBuf_, 0, n);
            char[] cArray = stringBuffer.toString().toCharArray();
            this.handler_.characters(cArray, 0, cArray.length);
        } else {
            this.handler_.characters(this.tmpBuf_, 0, n);
        }
    }

    private boolean isCdSect() throws ParseException, IOException {
        return this.isSymbol(BEGIN_CDATA);
    }

    private final Element readElement() throws ParseException, IOException {
        Element element = new Element();
        boolean bl = this.readEmptyElementTagOrSTag(element);
        this.handler_.startElement(element);
        if (bl) {
            this.readContent();
            this.readETag(element);
        }
        this.handler_.endElement(element);
        return element;
    }

    ParseLog getLog() {
        return this.log_;
    }

    private boolean readEmptyElementTagOrSTag(Element element) throws ParseException, IOException {
        boolean bl;
        this.readChar('<');
        element.setTagName(this.readName());
        while (this.isS()) {
            this.readS();
            if (this.isChar('/', '>')) continue;
            this.readAttribute(element);
        }
        if (this.isS()) {
            this.readS();
        }
        if (bl = this.isChar('>')) {
            this.readChar('>');
        } else {
            this.readSymbol(END_EMPTYTAG);
        }
        return bl;
    }

    private void readAttribute(Element element) throws ParseException, IOException {
        String string = this.readName();
        this.readEq();
        String string2 = this.readAttValue();
        if (element.getAttribute(string) != null) {
            this.log_.warning("Element " + this + " contains attribute " + string + "more than once", this.systemId_, this.getLineNumber());
        }
        element.setAttribute(string, string2);
    }

    private void readETag(Element element) throws ParseException, IOException {
        this.readSymbol(BEGIN_ETAG);
        String string = this.readName();
        if (!string.equals(element.getTagName())) {
            this.log_.warning("end tag (" + string + ") does not match begin tag (" + element.getTagName() + ")", this.systemId_, this.getLineNumber());
        }
        if (this.isS()) {
            this.readS();
        }
        this.readChar('>');
    }

    private boolean isETag() throws ParseException, IOException {
        return this.isSymbol(BEGIN_ETAG);
    }

    private void readContent() throws ParseException, IOException {
        this.readPossibleCharData();
        boolean bl = true;
        while (bl) {
            if (this.isETag()) {
                bl = false;
            } else if (this.isReference()) {
                char[] cArray = this.readReference();
                this.handler_.characters(cArray, 0, cArray.length);
            } else if (this.isCdSect()) {
                this.readCdSect();
            } else if (this.isPi()) {
                this.readPi();
            } else if (this.isComment()) {
                this.readComment();
            } else if (this.isChar('<')) {
                this.readElement();
            } else {
                bl = false;
            }
            this.readPossibleCharData();
        }
    }

    static {
        char c = '\u0000';
        while (c < '\u0080') {
            ParseCharStream.IS_NAME_CHAR[c] = ParseCharStream.isNameChar(c);
            c = (char)(c + '\u0001');
        }
        COMMENT_BEGIN = "<!--".toCharArray();
        COMMENT_END = "-->".toCharArray();
        PI_BEGIN = "<?".toCharArray();
        QU_END = "?>".toCharArray();
        DOCTYPE_BEGIN = "<!DOCTYPE".toCharArray();
        XML_BEGIN = "<?xml".toCharArray();
        ENCODING = "encoding".toCharArray();
        VERSION = "version".toCharArray();
        VERSIONNUM_PUNC_CHARS = new char[]{'_', '.', ':', '-'};
        MARKUPDECL_BEGIN = "<!".toCharArray();
        CHARREF_BEGIN = "&#".toCharArray();
        ENTITY_BEGIN = "<!ENTITY".toCharArray();
        NDATA = "NDATA".toCharArray();
        SYSTEM = "SYSTEM".toCharArray();
        PUBLIC = "PUBLIC".toCharArray();
        BEGIN_CDATA = "<![CDATA[".toCharArray();
        END_CDATA = "]]>".toCharArray();
        END_EMPTYTAG = "/>".toCharArray();
        BEGIN_ETAG = "</".toCharArray();
    }
}

