/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pinyin4j;

import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

class PinyinFormatter {
    PinyinFormatter() {
    }

    static String formatHanyuPinyin(String string, HanyuPinyinOutputFormat hanyuPinyinOutputFormat) throws BadHanyuPinyinOutputFormatCombination {
        if (HanyuPinyinToneType.WITH_TONE_MARK == hanyuPinyinOutputFormat.getToneType() && (HanyuPinyinVCharType.WITH_V == hanyuPinyinOutputFormat.getVCharType() || HanyuPinyinVCharType.WITH_U_AND_COLON == hanyuPinyinOutputFormat.getVCharType())) {
            throw new BadHanyuPinyinOutputFormatCombination("tone marks cannot be added to v or u:");
        }
        if (HanyuPinyinToneType.WITHOUT_TONE == hanyuPinyinOutputFormat.getToneType()) {
            string = string.replaceAll("[1-5]", "");
        } else if (HanyuPinyinToneType.WITH_TONE_MARK == hanyuPinyinOutputFormat.getToneType()) {
            string = string.replaceAll("u:", "v");
            string = PinyinFormatter.convertToneNumber2ToneMark(string);
        }
        if (HanyuPinyinVCharType.WITH_V == hanyuPinyinOutputFormat.getVCharType()) {
            string = string.replaceAll("u:", "v");
        } else if (HanyuPinyinVCharType.WITH_U_UNICODE == hanyuPinyinOutputFormat.getVCharType()) {
            string = string.replaceAll("u:", "\u00fc");
        }
        if (HanyuPinyinCaseType.UPPERCASE == hanyuPinyinOutputFormat.getCaseType()) {
            string = string.toUpperCase();
        }
        return string;
    }

    private static String convertToneNumber2ToneMark(String string) {
        String string2 = string.toLowerCase();
        if (string2.matches("[a-z]*[1-5]?")) {
            int n = 36;
            int n2 = -1;
            if (string2.matches("[a-z]*[1-5]")) {
                int n3;
                int n4 = Character.getNumericValue(string2.charAt(string2.length() - 1));
                int n5 = string2.indexOf(97);
                int n6 = string2.indexOf(101);
                int n7 = string2.indexOf("ou");
                if (-1 != n5) {
                    n2 = n5;
                    n = 97;
                } else if (-1 != n6) {
                    n2 = n6;
                    n = 101;
                } else if (-1 != n7) {
                    n2 = n7;
                    n = "ou".charAt(0);
                } else {
                    for (n3 = string2.length() - 1; n3 >= 0; --n3) {
                        if (!String.valueOf(string2.charAt(n3)).matches("[aeiouv]")) continue;
                        n2 = n3;
                        n = string2.charAt(n3);
                        break;
                    }
                }
                if (36 != n && -1 != n2) {
                    n3 = "aeiouv".indexOf(n);
                    int n8 = n4 - 1;
                    int n9 = n3 * 5 + n8;
                    char c = "\u0101\u00e1\u0103\u00e0a\u0113\u00e9\u0115\u00e8e\u012b\u00ed\u012d\u00eci\u014d\u00f3\u014f\u00f2o\u016b\u00fa\u016d\u00f9u\u01d6\u01d8\u01da\u01dc\u00fc".charAt(n9);
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(string2.substring(0, n2).replaceAll("v", "\u00fc"));
                    stringBuffer.append(c);
                    stringBuffer.append(string2.substring(n2 + 1, string2.length() - 1).replaceAll("v", "\u00fc"));
                    return stringBuffer.toString();
                }
                return string2;
            }
            return string2.replaceAll("v", "\u00fc");
        }
        return string2;
    }
}

