/*
 * Decompiled with CFR 0.152.
 */
package com.yccrc.common.utils;

import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.pagehelper.PageHelper;
import com.yccrc.common.core.page.PageDomain;
import com.yccrc.common.core.page.TableSupport;
import com.yccrc.common.utils.StringUtils;
import com.yccrc.common.utils.sql.SqlUtil;

public class PageUtils
extends PageHelper {
    public static void startPage() {
        PageDomain pageDomain = TableSupport.buildPageRequest();
        Integer pageNum = pageDomain.getPageNum();
        Integer pageSize = pageDomain.getPageSize();
        String orderBy = SqlUtil.escapeOrderBySql(pageDomain.getOrderBy());
        Boolean reasonable = pageDomain.getReasonable();
        PageHelper.startPage((int)pageNum, (int)pageSize, (String)orderBy).setReasonable(reasonable);
    }

    public static void clearPage() {
        PageHelper.clearPage();
    }

    public static <T> Page<T> initPage() {
        PageDomain pageDomain = TableSupport.buildPageRequest();
        Integer pageNum = pageDomain.getPageNum();
        Integer pageSize = pageDomain.getPageSize();
        String sort = pageDomain.getIsAsc();
        String orderBy = SqlUtil.escapeOrderBySql(pageDomain.getOrderBy());
        Page p = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        if (StringUtils.isNotEmpty(orderBy) && StringUtils.isNotEmpty(orderBy)) {
            boolean isAsc = true;
            if ("desc".equals(orderBy.toLowerCase())) {
                isAsc = false;
            }
            if (isAsc) {
                p.addOrder(new OrderItem[]{OrderItem.asc((String)sort)});
            } else {
                p.addOrder(new OrderItem[]{OrderItem.desc((String)sort)});
            }
        }
        return p;
    }
}

